<?php

/**
 * Fired during plugin activation
 *
 * @link       https://iqonic.design/
 * @since      1.0.0
 *
 * @package    Marvy_Pro_Animation_Addons
 * @subpackage Marvy_Pro_Animation_Addons/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Marvy_Pro_Animation_Addons
 * @subpackage Marvy_Pro_Animation_Addons/includes
 * @author     Iqonic Design <hello@iqonic.design>
 */
class Marvy_Pro_Animation_Addons_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
        $defaults =  array_fill_keys(array_keys($GLOBALS['marvy_pro_config']['bg-animation']), 1);

        $update_status = false;
        set_transient('marvy_animation_pro', '1', 0);
        // install lite version
        $is_lite = marvy_make_lite_version();
        if($is_lite){
            $values = get_option('marvy_option_settings');
            $update_status = update_option('marvy_option_settings', wp_parse_args($defaults,$values));
        };
        return $update_status;

	}

}
